*** Settings ***
Resource            /opt/robot-tests/tests/resources/common.resource
Library             /opt/robot-tests/tests/libraries/bodyRequests.py
Library             XML
Resource            /opt/robot-tests/tests/resources/common/basicRequests.robot
Resource            ../../resources/common.resource

Suite Teardown      Reset Testing Environment
Test Setup          Reset Testing Environment


*** Variables ***
${API_INVOKER_NOT_REGISTERED}       not-valid
${SUBSCRIBER_ID_NOT_VALID}          not-valid
${SUBSCRIPTION_ID_NOT_VALID}        not-valid


*** Test Cases ***
Creates a new individual CAPIF Event Subscription
    [Tags]    capif_api_events-1
    # Default Invoker Registration and Onboarding
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    ${request_body}=    Create Events Subscription
    ${resp}=    Post Request Capif
    ...    /capif-events/v1/${register_user_info_invoker['api_invoker_id']}/subscriptions
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    # Check Results
    Check Response Variable Type And Values    ${resp}    201    EventSubscription
    ${subscriber_id}    ${subscription_id}=    Check Event Location Header    ${resp}

Creates a new individual CAPIF Event Subscription with Invalid SubscriberId
    [Tags]    capif_api_events-2
    # Default Invoker Registration and Onboarding
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    ${request_body}=    Create Events Subscription
    ${resp}=    Post Request Capif
    ...    /capif-events/v1/${SUBSCRIBER_ID_NOT_VALID}/subscriptions
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    # Check Results
    Check Response Variable Type And Values    ${resp}    404    ProblemDetails
    ...    title=Not Found
    ...    status=404
    ...    detail=Invoker or APF or AEF or AMF Not found
    ...    cause=Subscriber Not Found

Deletes an individual CAPIF Event Subscription
    [Tags]    capif_api_events-3
    # Default Invoker Registration and Onboarding
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    ${request_body}=    Create Events Subscription
    ${resp}=    Post Request Capif
    ...    /capif-events/v1/${register_user_info_invoker['api_invoker_id']}/subscriptions
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    Check Response Variable Type And Values    ${resp}    201    EventSubscription

    ${subscriber_id}    ${subscription_id}=    Check Event Location Header    ${resp}

    ${resp}=    Delete Request Capif
    ...    /capif-events/v1/${subscriber_id}/subscriptions/${subscription_id}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    Status Should Be    204    ${resp}

Deletes an individual CAPIF Event Subscription with invalid SubscriberId
    [Tags]    capif_api_events-4
    # Default Invoker Registration and Onboarding
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    ${request_body}=    Create Events Subscription
    ${resp}=    Post Request Capif
    ...    /capif-events/v1/${register_user_info_invoker['api_invoker_id']}/subscriptions
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    Check Response Variable Type And Values    ${resp}    201    EventSubscription

    ${subscriber_id}    ${subscription_id}=    Check Event Location Header    ${resp}

    ${resp}=    Delete Request Capif
    ...    /capif-events/v1/${SUBSCRIBER_ID_NOT_VALID}/subscriptions/${subscription_id}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    # Check Results
    Check Response Variable Type And Values    ${resp}    404    ProblemDetails
    ...    title=Not Found
    ...    status=404
    ...    detail=Invoker or APF or AEF or AMF Not found
    ...    cause=Subscriber Not Found

Deletes an individual CAPIF Event Subscription with invalid SubscriptionId
    [Tags]    capif_api_events-5

    # Default Invoker Registration and Onboarding
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    ${request_body}=    Create Events Subscription
    ${resp}=    Post Request Capif
    ...    /capif-events/v1/${register_user_info_invoker['api_invoker_id']}/subscriptions
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    Check Response Variable Type And Values    ${resp}    201    EventSubscription

    ${subscriber_id}    ${subscription_id}=    Check Event Location Header    ${resp}

    ${resp}=    Delete Request Capif
    ...    /capif-events/v1/${subscriber_id}/subscriptions/${SUBSCRIPTION_ID_NOT_VALID}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    # Check Results
    Check Response Variable Type And Values    ${resp}    401    ProblemDetails
    ...    title=Unauthorized
    ...    detail=User not authorized
    ...    cause=You are not the owner of this resource

# Prueba Mock Server
#     [Tags]  jms-3
#     Start Mock server

# Prueba JMS
#     [Tags]    jms-1

#     # Start Mock server
#     Check Mock Server
#     Clean Mock Server

#     # Register APF
#     ${register_user_info}=    Provider Default Registration

#     # Publish one api
#     Publish Service Api    ${register_user_info}

#     # Register INVOKER
#     ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

#     ${discover_response}=    Get Request Capif
#     ...    ${DISCOVER_URL}${register_user_info_invoker['api_invoker_id']}
#     ...    server=${CAPIF_HTTPS_URL}
#     ...    verify=ca.crt
#     ...    username=${INVOKER_USERNAME}

#     ${api_ids}    ${api_names}=    Get Api Ids And Names From Discover Response    ${discover_response}

#     # Subscribe to events
#     ${events_list}=    Create List    SERVICE_API_INVOCATION_SUCCESS    SERVICE_API_INVOCATION_FAILURE
#     ${request_body}=    Create Events Subscription
#     ...    events=@{events_list}
#     ...    notificationDestination=http://192.168.0.14:9090/testing
#     ${resp}=    Post Request Capif
#     ...    /capif-events/v1/${register_user_info_invoker['api_invoker_id']}/subscriptions
#     ...    json=${request_body}
#     ...    server=${CAPIF_HTTPS_URL}
#     ...    verify=ca.crt
#     ...    username=${INVOKER_USERNAME}

#     # Check Results
#     Check Response Variable Type And Values    ${resp}    201    EventSubscription
#     ${subscriber_id}    ${subscription_id}=    Check Event Location Header    ${resp}

#     ${results}=    Create List    200    400

#     # Create Log Entry
#     ${request_body}=    Create Log Entry
#     ...    ${register_user_info['aef_id']}
#     ...    ${register_user_info_invoker['api_invoker_id']}
#     ...    ${api_ids}
#     ...    ${api_names}
#     ...    results=${results}
#     ${resp}=    Post Request Capif
#     ...    /api-invocation-logs/v1/${register_user_info['aef_id']}/logs
#     ...    json=${request_body}
#     ...    server=${CAPIF_HTTPS_URL}
#     ...    verify=ca.crt
#     ...    username=${AEF_PROVIDER_USERNAME}

#     # Check Results
#     Check Response Variable Type And Values    ${resp}    201    InvocationLog
#     ${resource_url}=    Check Location Header    ${resp}    ${LOCATION_LOGGING_RESOURCE_REGEX}

#     Sleep    3s

#     # Get from Mock server the EventNotification Messages sent to callback setup on event subscription.
#     ${resp}=    Get Mock Server Messages
#     ${notification_events_on_mock_server}=    Set Variable    ${resp.json()}
#     # Check if message follow EventNotification definition.
#     Check Variable    ${notification_events_on_mock_server}    EventNotification
#     # Check if mock server receive 2 events.
#     Length Should Be    ${notification_events_on_mock_server}    2

#     # Now we create the expected events received at notification server according to logs sent to loggin service in order to check if all are present.
#     ${invocation_log_base}=    Copy Dictionary    ${request_body}    deepcopy=True

#     # Store log array because each log will be notified in one Event Notification
#     ${invocation_log_logs}=    Set Variable    ${invocation_log_base['logs']}
#     # Remove logs array from invocationLog data
#     Remove From Dictionary    ${invocation_log_base}    logs
#     Length Should Be    ${invocation_log_logs}    2

#     # Create 2 invocationLogs from initial invocationLog present on request
#     ${invocation_logs_1}=    Copy Dictionary    ${invocation_log_base}    deepcopy=True
#     ${invocation_logs_2}=    Copy Dictionary    ${invocation_log_base}    deepcopy=True
#     # Create a log array with only one component
#     ${log_1}=    Create List    ${invocation_log_logs[0]}
#     ${log_2}=    Create List    ${invocation_log_logs[1]}
#     # Setup logs array with previously created list
#     Set To Dictionary    ${invocation_logs_1}    logs=${log_1}
#     Set To Dictionary    ${invocation_logs_2}    logs=${log_2}
#     # Create event details for each log
#     ${event_details_1}=    Create dictionary    invocationLogs=${invocation_logs_1}
#     ${event_details_2}=    Create dictionary    invocationLogs=${invocation_logs_2}
#     # Create Event with Event Details from invocationLog
#     ${event_1}=    Create Dictionary
#     ...    subscriptionId=${subscription_id}
#     ...    events=SERVICE_API_INVOCATION_SUCCESS
#     ...    eventDetail=${event_details_1}
#     ${event_2}=    Create Dictionary
#     ...    subscriptionId=${subscription_id}
#     ...    events=SERVICE_API_INVOCATION_FAILURE
#     ...    eventDetail=${event_details_2}
#     # Check if created events follow EventNotification format defined by 3gpp
#     Check Variable    ${event_1}    EventNotification
#     Check Variable    ${event_2}    EventNotification

#     List Should Contain Value    ${notification_events_on_mock_server}    ${event_1}
#     List Should Contain Value    ${notification_events_on_mock_server}    ${event_2}

Prueba JMS
    [Tags]    jms-2

    # Start Mock server
    Check Mock Server
    Clean Mock Server

    # Register APF
    ${register_user_info}=    Provider Default Registration

    # Publish one api
    Publish Service Api    ${register_user_info}

    # Register INVOKER
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    ${discover_response}=    Get Request Capif
    ...    ${DISCOVER_URL}${register_user_info_invoker['api_invoker_id']}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    ${api_ids}    ${api_names}=    Get Api Ids And Names From Discover Response    ${discover_response}

    # Subscribe to events
    ${events_list}=    Create List    SERVICE_API_INVOCATION_SUCCESS    SERVICE_API_INVOCATION_FAILURE
    ${request_body}=    Create Events Subscription
    ...    events=@{events_list}
    ...    notificationDestination=http://192.168.0.14:9090/testing
    ${resp}=    Post Request Capif
    ...    /capif-events/v1/${register_user_info_invoker['api_invoker_id']}/subscriptions
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    # Check Results
    Check Response Variable Type And Values    ${resp}    201    EventSubscription
    ${subscriber_id}    ${subscription_id}=    Check Event Location Header    ${resp}

    ${results}=    Create List    200    400

    # Create Log Entry
    ${request_body}=    Create Log Entry
    ...    ${register_user_info['aef_id']}
    ...    ${register_user_info_invoker['api_invoker_id']}
    ...    ${api_ids}
    ...    ${api_names}
    ...    results=${results}
    ${resp}=    Post Request Capif
    ...    /api-invocation-logs/v1/${register_user_info['aef_id']}/logs
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${AEF_PROVIDER_USERNAME}

    # Check Results
    Check Response Variable Type And Values    ${resp}    201    InvocationLog
    ${resource_url}=    Check Location Header    ${resp}    ${LOCATION_LOGGING_RESOURCE_REGEX}

    Sleep    3s

    # Get from Mock server the EventNotification Messages sent to callback setup on event subscription.
    ${resp}=    Get Mock Server Messages
    ${notification_events_on_mock_server}=    Set Variable    ${resp.json()}
    # Check if message follow EventNotification definition.
    Check Variable    ${notification_events_on_mock_server}    EventNotification

    # Create check Events to ensure all notifications were received
    ${check_events}    ${check_events_length}=    Create Events From invocationLogs
    ...    ${subscription_id}
    ...    ${request_body}

    # Number of events received must be equal than events expected
    Length Should Be    ${notification_events_on_mock_server}    ${check_events_length}
    # Check if events received are the same than expected
    FOR    ${event}    IN    @{check_events}
        Log    ${event}
        List Should Contain Value    ${notification_events_on_mock_server}    ${event}
    END
